from django.urls import path, re_path
from .views import (
    CheckoutView, ItemDetailView, 
    HomeView, 
    add_to_cart, 
    remove_from_cart, 
    OrderSummaryView, 
    add_to_cart_home, 
    remove_item_from_cart, 
    add_to_cart_summary,
    remove_whole_from_cart,
    ShopView
    )

app_name = 'core'
urlpatterns = [
    path('', HomeView.as_view(), name='home'),
    path('checkout/', CheckoutView.as_view(), name='checkout'),
    path('product/<slug>/', ItemDetailView.as_view(), name='product'),
    path('add-to-cart/<slug>/', add_to_cart, name='add-to-cart'),
    path('add-to-cart-home/<slug>/', add_to_cart_home, name='add-to-cart-home'),
    path('add-to-cart-summary/<slug>/', add_to_cart_summary, name='add-to-cart-summary'),   
    path('remove-from-cart/<slug>/', remove_from_cart, name='remove-from-cart'),
    path('remove-item-from-cart/<slug>/', remove_item_from_cart, name='remove-item-from-cart'),
    path('remove-whole-from-cart/<slug>/', remove_whole_from_cart, name='remove-whole-from-cart'),
    path('order-summary/', OrderSummaryView.as_view(), name='order-summary'),
    path('shop', ShopView.as_view(), name='shop'),

]

