from logging import PlaceHolder
from random import choices
from django import forms
from django_countries.fields import CountryField
from django_countries.widgets import CountrySelectWidget
#from pytz import country_names

PAYMENT_CHOICES = (
    ('M', 'Mpesa'),
    ('P', 'Paypal'),
    ('S','Stripe')
)

class CheckoutForm(forms.Form):
    FirstName = forms.CharField(max_length=100,widget=forms.TextInput(attrs={
        'class': 'form-control'
    }))

    LastName = forms.CharField(max_length=100, widget=forms.TextInput(attrs={
        'class': 'form-control'
    }))

    UserName = forms.CharField(max_length=100, widget=forms.TextInput(attrs={
        'class': 'form-control py-0',
        'placeholder': 'Username'
    }))

    Email = forms.EmailField(widget=forms.TextInput(attrs={
        'placeholder': 'youremail@example.com',
        'class': 'form-control'
    }))

    street_address = forms.CharField(widget=forms.TextInput(attrs={
        'placeholder': '1234 Main St',
        'class': 'form-control'

    }))
    apartment_address = forms.CharField(required=False, widget=forms.TextInput(attrs={
        'placeholder': 'Apartment or suite',
        'class': 'form-control'
    }))
    country = CountryField(blank_label='(Select Country)').formfield(widget=CountrySelectWidget(attrs={
        'class': 'custom-select d-block w-100'
    }))
    zip = forms.CharField(widget=forms.TextInput(attrs={
        'class': 'form-control'
    }))
    same_shipping_address = forms.BooleanField(required=False, widget=forms.CheckboxInput())
    save_info = forms.BooleanField(required=False, widget=forms.CheckboxInput())
    payment_option = forms.ChoiceField(widget=forms.RadioSelect, choices=PAYMENT_CHOICES)